<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" 
    xmlns:amazon="http://webservices.amazon.com/AWSECommerceService/2005-07-26" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xalan="http://xml.apache.org/xslt"
    exclude-result-prefixes="amazon xalan">
    
  <xsl:output method="html" version="1.0" encoding="utf-8" indent="yes" omit-xml-declaration="yes"
      doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
      doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
      xalan:indent-amount="2"/>
  
  <!-- include reference to service version -->
  <!-- must mactch the namespace declared above -->
  <xsl:include href="version.xsl"/>
  <xsl:include href="key.xsl"/>
  
  <xsl:param name="id"/>
  <xsl:param name="locale"/>

  <xsl:variable name="root">http://webservices.amazon</xsl:variable>
  <xsl:variable name="total-service">/onca/xml?Service=AWSECommerceService&amp;Operation=ListLookup&amp;ListType=WishList</xsl:variable>
  <xsl:variable name="lookup-service">/onca/xml?Service=AWSECommerceService&amp;Operation=ListLookup&amp;ListType=WishList&amp;ResponseGroup=ItemAttributes,Images,Offers,ListItems</xsl:variable>

  <!-- return the info about the list specifically the number of items and pages -->  
  <xsl:template match="amazon">
    <xsl:variable name="pages" select="concat($root, $locale, $total-service, '&amp;ListId=', $id, '&amp;SubscriptionId=', $key, '&amp;Version=', $version)"/>
    <xsl:variable name="total-pages" select="document($pages)//amazon:TotalPages"/>

    <html>          
      <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>Amazon Wishlist <xsl:value-of select="$id"/></title>
        <link rel="stylesheet" href="/amazon.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="/print.css" type="text/css" media="print" />       
      </head>
      <body>
        <div id="masthead">
          <div id="container">
          <div id="logo">
            <a href="/"><img src="/logo.jpg" alt="xefer" /></a>
          </div>
          <div id="navbar">
            <a href="http://www.xefer.com/">home</a> <a href="http://www.xefer.com/archives/">archives</a> 
            <a href="http://www.xefer.com/iuncturae/">iunctur&#230;</a> <a href="http://www.xefer.com/cell">debris</a>   
          </div>
          <div id="escutcheon">
            <img src="/sun.jpg" alt="escutcheon" />
          </div>
        </div>
      </div>        
      <div id="content">
        <table class="compact" border="1" cellpadding="3" width="100%" cellspacing="0">
          <thead>
            <tr>
              <td>Title</td><td>Author</td><td>Price</td>
            </tr>
          </thead>
          <tbody>
            <xsl:call-template name="counter">
              <xsl:with-param name="total" select="number($total-pages)"/>
              <xsl:with-param name="page" select="1"/>
            </xsl:call-template>  
          </tbody>
        </table>
        </div>
      </body>
    </html>        
     
  </xsl:template>
  
  <!-- recursively count through the pages -->
  <xsl:template name="counter">
    <xsl:param name="total"/>
    <xsl:param name="page"/>
    
    <xsl:if test="$page &lt;= $total">
      <xsl:apply-templates select="document(concat($root, $locale, $lookup-service, '&amp;ListId=', $id, '&amp;SubscriptionId=', $key, '&amp;ProductPage=', $page, '&amp;Version=', $version))"/>          
      <xsl:call-template name="counter">
        <xsl:with-param name="total" select="$total"/>
        <xsl:with-param name="page" select="$page + 1"/>
      </xsl:call-template>
    </xsl:if>
    
  </xsl:template>
 
  <!-- burn off nodes we don't care about -->
  <xsl:template match="@*|node()">
    <xsl:apply-templates select="@*|node()"/>
  </xsl:template>
  
  <xsl:template match="amazon:Item">
    <xsl:if test="not(preceding-sibling::amazon:QuantityReceived) or number(preceding-sibling::amazon:QuantityReceived) &lt; number(preceding-sibling::amazon:QuantityDesired)">
      <tr>
        <xsl:apply-templates select="amazon:ItemAttributes"/>
      </tr>
    </xsl:if>
  </xsl:template>

  <xsl:template match="amazon:ItemAttributes">
    <xsl:variable name="price" select="following::amazon:Price/amazon:FormattedPrice"/>
    <xsl:variable name="lownew" select="following::amazon:LowestNewPrice/amazon:FormattedPrice"/>
    <xsl:variable name="lowused" select="following::amazon:LowestUsedPrice/amazon:FormattedPrice"/>
    <xsl:variable name="maker" select="amazon:Author | amazon:Artist | amazon:Director | amazon:Manufacturer | amazon:Creator | amazon:Publisher"/>
    <xsl:variable name="title" select="amazon:Title"/>
    <xsl:variable name="asin" select="preceding-sibling::amazon:ASIN"/>
    
    <td>
      <a>
        <!-- include link to appropriate internation Amazon location -->
        <xsl:attribute name="href">
          <xsl:value-of select="concat('http://amazon', $locale, '/o/asin/', $asin)"/>
        </xsl:attribute>
        <!-- remove subtitle -->
        <xsl:choose>
          <xsl:when test="contains($title, ':')">
            <xsl:value-of select="substring-before($title,':')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$title"/>     
          </xsl:otherwise>
        </xsl:choose>
      </a>
    </td>
    <td>
      <xsl:value-of select="$maker"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="$price">
          <xsl:value-of select="$price"/>
        </xsl:when>
        <xsl:when test="$lownew">
          <xsl:value-of select="$lownew"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$lowused"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>  
  </xsl:template>

</xsl:stylesheet>